<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Movie Banner</title>
    <style>
            body {
    margin: 0;
    padding: 0;
    width: 100%;
    height: 100%;
}

body {
    display: flex;
    justify-content: center;
    align-items: center;
    overflow: hidden;
    background-image: url('https://i.postimg.cc/j2zgYRqn/Inserir-um-t-tulo-19.png'); /* Imagem de fundo */
    background-size: cover; /* Ajusta a imagem para cobrir toda a área do container */
    background-position: center; /* Centraliza a imagem */
    background-repeat: no-repeat; /* Evita repetição da imagem */
}

        .banner-container {
            width: 100%;
            height: 100vh; /* Ocupa a tela inteira */
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .movie-poster {
             width: 100%;
            height: 100vh; /* Ocupa a tela inteira */
            max-height: 100vh; /* Altura máxima para se ajustar ao banner */
            transition: opacity 0.5s ease; /* Suave transição de troca */
            opacity: 0;
            position: absolute;
        }

        .movie-poster.active {
            opacity: 1; /* Mostrar apenas a imagem ativa */
        }
    </style>
</head>
<body>
    <div class="banner-container" id="movie-banner">
        <!-- Pôsteres dos filmes serão adicionados aqui -->
    </div>

    <script>
        const apiKey = '6b8e3eaa1a03ebb45642e9531d8a76d2'; // Insira sua chave de API do TMDb
        let movieIds = [];
        let currentPosterIndex = 0;

        async function fetchPopularMovieIds() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&language=en-US`);
                const data = await response.json();
                movieIds = data.results.map(movie => movie.id);
            } catch (error) {
                console.error(error);
            }
        }

        async function updateMovieBanner() {
            if (movieIds.length === 0) {
                console.error('Não foi possível carregar os IDs dos filmes.');
                return;
            }

            const movieId = movieIds[currentPosterIndex];
            
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}`);
                const data = await response.json();
                
                const movieBanner = document.getElementById('movie-banner');
                const posterPath = `https://image.tmdb.org/t/p/original${data.poster_path}`;
                const moviePoster = document.createElement('img');
                moviePoster.src = posterPath;
                moviePoster.alt = data.title;
                moviePoster.className = 'movie-poster';
                
                // Tornar o novo pôster o ativo e remover o anterior
                movieBanner.appendChild(moviePoster);
                const posters = document.querySelectorAll('.movie-poster');
                posters.forEach(poster => poster.classList.remove('active'));
                moviePoster.classList.add('active');
                
                // Remover pôsteres antigos após exibição para economizar memória
                if (posters.length > 1) {
                    posters[0].remove();
                }
                
                // Atualizar o índice
                currentPosterIndex = (currentPosterIndex + 1) % movieIds.length;
            } catch (error) {
                console.error(error);
            }
        }

        fetchPopularMovieIds().then(() => {
            // Atualizar o banner a cada 5 segundos
            setInterval(updateMovieBanner, 5000); // Ajustar o tempo de transição
        });
    </script>
</body>
</html>
